classdef HW2Scenario
    %Homework 2 base class
    %  
    % Copyright (C) Russell H. Taylor 2013
    % For use with CIS I only
    % Do not redistribute without written permission from Russell Taylor
    
    properties
        N;         % Number of markers
        Markers;   % Markers WRT head holder
        dP;
        Fh;        % headholder WRT robot base
        Fs;        % Spect sensor WRT robot end effector
        Frc;       % Stereo camera WRT robot end effector
        Frob;      % Last position of the robot
        
        LastFrobList % used in debugging
        LastFchList  % 
        LastFaList   %
        LastFbList   %
        LastMlist    %
    end
    
    methods
        function H = HW2Scenario(dP)
            H.N=13; r = 100;
            H.Markers = vct3Array(H.N);
            for m=1:H.N
                theta = (m-1)*15-180;
                H.Markers(m)=vct3(cosd(theta)*r,sind(theta)*r,0);
            end
            H.dP = dP;
            H.Fh = Frame(RotMx.eye(),vct3(500,500,200));
            H.Fs = Frame(RotMx.xyzD(0,180,0),vct3(0,0,0));
            H.Frc = Frame(RotMx.xyzD(0,180,0),vct3(150,0,0));
            H.Frob = Frame(RotMx.eye(),vct3(500,500,500));
        end
        
        function aMarkers = PositionRobotAndFindMarkers(H,Frob)
            if nargin>1
                H.Frob=Frob;
            end
            aMarkers = vct3Array(H.N);
            Fc = H.Frob*H.Frc;
            Fch = Fc.Inverse()*H.Fh;
            for m=1:H.N
                a =Fch*H.Markers(m);
                aMarkers(m) = a + vct3.rand(H.dP);
            end
        end 
        
        function Err = FrcErrorMag(H,Fest)
            Fe = H.Frc.Inverse()*Fest;
            [Ax,An]=Fe.R.AxisAngle();
            Err = [An*180/pi,Fe.p.norm()];
        end
        
    end
    
end

